-- Speed field in the editor defines the time delay between drops

local SPHERICAL = 1
local FALLING_DROP = 2
local MAX_FALLING_SPEED = 12

function main(self)
	local claw = GetClaw()

    if self.State == 0 then
		self:SetImage("CUSTOM_WATER_DROP")
		self.MoveRect = {-4,-4,4,8}
		self.PhysicsType = 8
		self.startingY = self.Y
		if self.Speed == 0 then
			self.Speed = math.random(2000,3000)
		end
		self.State = 1
	end

	if self.State == 1 then
		self.timeCounter = GetTime() + self.Speed/10
		self.State = 2
	end

	if self.State == 2 and GetTime() > self.timeCounter then
		self:SetFrame(FALLING_DROP)
		self.timeCounter = GetTime()
		self.SpeedY = 1 -- a minimal speed for start
		self.State = 3
	end

	if self.State == 3 then
		if self.SpeedY < MAX_FALLING_SPEED then
			self.SpeedY = math.floor((GetTime() - self.timeCounter)/60) + 1
		end
		local pf = self:Physics(self.X, self.Y + self.SpeedY)
		if self.Y > self.startingY + 64 and pf >= PhysicsFlags.ElevatorLand then
			self.State = 4
		end
	end

	if self.State == 4 then
		CreateObject{X=self.X, Y=self.Y, Z=3000, name="WaterDropSplash"}
		if self.X < claw.X + 500 and self.X > claw.X - 500 and self.Y < claw.Y + 500 and self.Y > claw.Y - 500 then
			PlaySound("CUSTOM_WATERDROP_100" .. math.random(4))
		end
		self.SpeedY = 0
		self.DrawFlags.NoDraw = true
		self.timeCounter = GetTime() + self.Speed
		self.State = 5
	end

	if self.State == 5 and GetTime() > self.timeCounter then
		self.Y = self.startingY
		self.DrawFlags.NoDraw = false
		self:SetFrame(SPHERICAL)
		self.State = 1
	end

end